/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.api.behavior;

import dev.lambdaurora.lambdynlights.api.behavior.DynamicLightBehavior;
import net.minecraft.class_2338;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class LineLightBehavior
implements DynamicLightBehavior {
    private Vector3d startPoint;
    private Vector3d endPoint;
    private Vector3d prevStartPoint;
    private Vector3d prevEndPoint;
    private int luminance;
    private int prevLuminance;

    public LineLightBehavior(Vector3d startPoint, Vector3d endPoint, int luminance) {
        this.startPoint = startPoint;
        this.endPoint = endPoint;
        this.prevStartPoint = null;
        this.prevEndPoint = null;
        this.luminance = luminance;
    }

    public Vector3d getStartPoint() {
        return this.startPoint;
    }

    public void setStartPoint(Vector3d startPoint) {
        this.startPoint = startPoint;
    }

    public void setStartPoint(double x, double y, double z) {
        this.startPoint.set(x, y, z);
    }

    public Vector3d getEndPoint() {
        return this.endPoint;
    }

    public void setEndPoint(Vector3d endPoint) {
        this.endPoint = endPoint;
    }

    public void setEndPoint(double x, double y, double z) {
        this.endPoint.set(x, y, z);
    }

    public int getLuminance() {
        return this.luminance;
    }

    public void setLuminance(int luminance) {
        this.luminance = luminance;
    }

    @Override
    public @Range(from=0L, to=15L) double lightAtPos(class_2338 pos, double falloffRatio) {
        Vector3d line = new Vector3d((Vector3dc)this.endPoint).sub((Vector3dc)this.startPoint);
        Vector3d pointToStart = new Vector3d((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5).sub((Vector3dc)this.startPoint);
        Vector3d vector3d = new Vector3d((Vector3dc)pointToStart);
        if (vector3d.dot((Vector3dc)line) <= 0.0) {
            return (double)this.luminance - pointToStart.length() * falloffRatio;
        }
        Vector3d pointToEnd = new Vector3d((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5).sub((Vector3dc)this.endPoint);
        Vector3d vector3d2 = new Vector3d((Vector3dc)pointToEnd);
        if (vector3d2.dot((Vector3dc)line) >= 0.0) {
            return (double)this.luminance - pointToEnd.length() * falloffRatio;
        }
        double distance = new Vector3d((Vector3dc)line).cross((Vector3dc)pointToStart).length() / line.length();
        return (double)this.luminance - distance * falloffRatio;
    }

    @Override
    public boolean hasChanged() {
        if (!this.startPoint.equals((Object)this.prevStartPoint) || !this.endPoint.equals((Object)this.prevEndPoint) || this.luminance != this.prevLuminance) {
            this.prevStartPoint = new Vector3d((Vector3dc)this.startPoint);
            this.prevEndPoint = new Vector3d((Vector3dc)this.endPoint);
            this.prevLuminance = this.luminance;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public DynamicLightBehavior.BoundingBox getBoundingBox() {
        return new DynamicLightBehavior.BoundingBox(class_3532.method_15357((double)this.startPoint.x()), class_3532.method_15357((double)this.startPoint.y()), class_3532.method_15357((double)this.startPoint.z()), class_3532.method_15384((double)this.endPoint.x()), class_3532.method_15384((double)this.endPoint.y()), class_3532.method_15384((double)this.endPoint.z()));
    }
}

